﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB
{
    public partial class RegistryInfo : BasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);

                if (UserSession == null || UserSession.CurrentRegistryId <= 0)
                {
                    Response.Redirect("~/Default.aspx", false);
                }
                else
                {
                    LoadForm(UserSession.CurrentRegistryId);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        public void LoadForm(int id)
        {
            STD_REGISTRY registry = ServiceInterfaceManager.STD_REGISTRY_GET_COMPLETE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, id);
            if (registry != null)
            {
                lblRegistryNameValue.Text = AntiXssEnc.Encoder.HtmlEncode((registry.NAME == string.Empty ? "N/A" : registry.NAME));
                lblRegistryCodeValue.Text = AntiXssEnc.Encoder.HtmlEncode((registry.CODE == string.Empty ? "N/A" : registry.CODE));
                lblRegistryDescriptionValue.Text = AntiXssEnc.Encoder.HtmlEncode((registry.DESCRIPTION_TEXT == string.Empty ? "N/A" : registry.DESCRIPTION_TEXT));
                if (!registry.INACTIVE_FLAG)
                    lblRegistryStatusValue.Text = "Enabled";
                else
                    lblRegistryStatusValue.Text = "Disabled";

                if (registry.REGISTRY_OWNER_USER != null)
                    lblRegistryOwnerValue.Text = AntiXssEnc.Encoder.HtmlEncode((registry.REGISTRY_OWNER_USER.FULL_NAME == string.Empty ? "N/A" : registry.REGISTRY_OWNER_USER.FULL_NAME));
                else
                    lblRegistryOwnerValue.Text = "N/A";

                if (registry.REGISTRY_ADMINISTRATOR_USER != null)
                    lblRegistryAdministratorValue.Text = AntiXssEnc.Encoder.HtmlEncode((registry.REGISTRY_ADMINISTRATOR_USER.FULL_NAME == string.Empty ? "N/A" : registry.REGISTRY_ADMINISTRATOR_USER.FULL_NAME));
                else
                    lblRegistryAdministratorValue.Text = "N/A";

                if (registry.SUPPORT_CONTACT_USER != null)
                    lblSupportContactValue.Text = AntiXssEnc.Encoder.HtmlEncode((registry.SUPPORT_CONTACT_USER.FULL_NAME == string.Empty ? "N/A" : registry.SUPPORT_CONTACT_USER.FULL_NAME));
                else
                    lblSupportContactValue.Text = "N/A";
            }
        }
    }
}